Imports Microsoft.VisualBasic
Imports System.Data
Imports System.Data.SqlClient

Public Class DiaryEntry
    Const conString As String = "Data Source=.\SQLEXPRESS;AttachDbFilename=|DataDirectory|\DiaryDB.mdf;Integrated Security=True;User Instance=True"
    Private mDiaryId As Integer
    Private mDiaryEntryId As Long
    Private mEntryText As String = "Wprowad tutaj tekst wpisu"
    Private mEntryTitle As String = "Bez tytuu"
    Private mEntryDate As Date = Now()

#Region "Definicje waciwoci"

  Public Property EntryText() As String
    Get
      EntryText = mEntryText
    End Get
    Set(ByVal entryTextValue As String)
      mEntryText = entryTextValue
    End Set
  End Property

  Public Property EntryDate() As Date
    Get
      EntryDate = mEntryDate
    End Get
    Set(ByVal entryDateValue As Date)
      mEntryDate = entryDateValue
    End Set
  End Property

  Public Property EntryTitle() As String
    Get
      EntryTitle = mEntryTitle
    End Get
    Set(ByVal entryTitleValue As String)
      mEntryTitle = entryTitleValue
    End Set
  End Property

#End Region

#Region "Konstruktory"
  Public Sub New(ByVal DiaryId As Integer)
    mDiaryEntryId = -1
    mDiaryId = DiaryId
  End Sub

  Public Sub New(ByVal DiaryEntryId As Long)
    mDiaryEntryId = DiaryEntryId
    If mDiaryEntryId <> -1 Then
      Try

        Dim diaryDBConn As New SqlConnection(conString)
        Dim sqlString As String = "GetDiaryEntryById"
        Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
        sqlCmd.CommandType = CommandType.StoredProcedure

        sqlCmd.Parameters.AddWithValue("@DiaryEntryId", mDiaryEntryId)

        diaryDBConn.Open()
        Dim diaryEntrySQLDR As SqlDataReader = sqlCmd.ExecuteReader(CommandBehavior.CloseConnection)
        diaryDBConn.Close()
        sqlCmd = Nothing
        diaryDBConn = Nothing
        If diaryEntrySQLDR.Read() Then
          mEntryDate = CDate(diaryEntrySQLDR("EntryDate"))
          mEntryTitle = diaryEntrySQLDR("EntryTitle").ToString
          mEntryText = diaryEntrySQLDR("EntryText").ToString
          mDiaryId = CInt(diaryEntrySQLDR("DiaryId"))

        Else
          mDiaryEntryId = -1
        End If

        diaryEntrySQLDR.Close()
        diaryEntrySQLDR = Nothing
      Catch ex As Exception
        mDiaryEntryId = -1
      End Try

    End If
  End Sub

  Public Sub New(ByVal DiaryId As Integer, ByVal EntryDate As Date)
    mDiaryId = DiaryId
    If mDiaryId > 0 Then
      Try

        Dim diaryDBConn As New SqlConnection(conString)
        Dim sqlString As String = "GetDiaryEntryByDate"
        Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
        sqlCmd.CommandType = CommandType.StoredProcedure

        sqlCmd.Parameters.AddWithValue("@DiaryId", mDiaryId)
        sqlCmd.Parameters.AddWithValue("@EntryFromDate", EntryDate)
        sqlCmd.Parameters.AddWithValue("@EntryToDate", EntryDate)


        diaryDBConn.Open()
        Dim diaryEntrySQLDR As SqlDataReader = sqlCmd.ExecuteReader(CommandBehavior.CloseConnection)
        sqlCmd = Nothing
        If diaryEntrySQLDR.Read() Then
          mDiaryEntryId = CLng(diaryEntrySQLDR("DiaryEntryId"))
          mEntryDate = CDate(diaryEntrySQLDR("EntryDate"))
          mEntryTitle = diaryEntrySQLDR("EntryTitle").ToString
          mEntryText = diaryEntrySQLDR("EntryText").ToString
        Else
          mDiaryEntryId = -1
          mEntryDate = EntryDate
        End If

        diaryEntrySQLDR.Close()
        diaryEntrySQLDR = Nothing
        diaryDBConn.Close()
        diaryDBConn = Nothing

      Catch ex As Exception
        mDiaryEntryId = -1
      End Try

    End If
  End Sub
#End Region

#Region "Skadniki prywatne"
  Private Sub UpdateDiaryEntry()
    If mDiaryEntryId <> -1 Then
      Dim diaryDBConn As New SqlConnection(conString)
      Dim sqlString As String = "UpdateDiaryEntry"
      Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
      sqlCmd.CommandType = CommandType.StoredProcedure

      sqlCmd.Parameters.AddWithValue("@DiaryEntryId", mDiaryEntryId)
      sqlCmd.Parameters.AddWithValue("@EntryDate", mEntryDate)
      sqlCmd.Parameters.AddWithValue("@EntryTitle", mEntryTitle)
      sqlCmd.Parameters.AddWithValue("@EntryText", mEntryText)

      diaryDBConn.Open()
      sqlCmd.ExecuteNonQuery()
      diaryDBConn.Close()
      sqlCmd = Nothing
      diaryDBConn = Nothing
    End If

  End Sub

  Private Sub InsertNewDiaryEntry()
    If mDiaryId <> -1 Then
      Dim diaryDBConn As New SqlConnection(conString)
      Dim sqlString As String = "InsertDiaryEntry"
      Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
      sqlCmd.CommandType = CommandType.StoredProcedure

      sqlCmd.Parameters.AddWithValue("@DiaryId", mDiaryId)
      sqlCmd.Parameters.AddWithValue("@EntryDate", mEntryDate)
      sqlCmd.Parameters.AddWithValue("@EntryTitle", mEntryTitle)
      sqlCmd.Parameters.AddWithValue("@EntryText", mEntryText)
      sqlCmd.Parameters.Add("@NewDiaryEntryId", SqlDbType.BigInt)
      sqlCmd.Parameters("@NewDiaryEntryId").Direction = ParameterDirection.ReturnValue

      diaryDBConn.Open()
      sqlCmd.ExecuteNonQuery()
      mDiaryEntryId = CLng(sqlCmd.Parameters("@NewDiaryEntryId").Value())

      diaryDBConn.Close()
      sqlCmd = Nothing
      diaryDBConn = Nothing
    End If
  End Sub
#End Region

#Region "Wspuytkowane funkcje publiczne"

    Public Shared Function GetDaysInMonthWithEntries(ByVal DiaryId As Integer, ByVal Month As Integer, ByVal Year As Integer) As Boolean()
        Dim DaysInMonth As Integer = System.DateTime.DaysInMonth(Year, Month)
        Dim DaysWithEntries(DaysInMonth) As Boolean
        Dim diaryDBConn As New SqlConnection(conString)
        Dim sqlString As String = "GetDaysWithEntries"
        Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
        sqlCmd.CommandType = CommandType.StoredProcedure

        Dim FromDate As New Date(Year, Month, 1)
        Dim ToDate As New Date(Year, Month, DaysInMonth)

        sqlCmd.Parameters.AddWithValue("@DiaryId", DiaryId)
        sqlCmd.Parameters.AddWithValue("@EntryFromDate", FromDate)
        sqlCmd.Parameters.AddWithValue("@EntryToDate", ToDate)

        diaryDBConn.Open()
        Dim EntriesQLDR As SqlDataReader = sqlCmd.ExecuteReader(CommandBehavior.CloseConnection)

        sqlCmd = Nothing

        Do While EntriesQLDR.Read()
            DaysWithEntries(CInt(EntriesQLDR(0))) = True
        Loop
        EntriesQLDR.Close()
        EntriesQLDR = Nothing
        diaryDBConn.Close()
        diaryDBConn = Nothing

        Return DaysWithEntries

    End Function

    Public Shared Function GetDiaryEntriesRecentlyChanged(ByVal DiaryId As Integer) As SqlDataReader
        Dim diaryDBConn As New SqlConnection(conString)
        Dim sqlString As String = "GetRecentDiaryEntries"
        Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
        sqlCmd.CommandType = CommandType.StoredProcedure

        sqlCmd.Parameters.AddWithValue("@DiaryId", DiaryId)

        diaryDBConn.Open()
        Dim entrySQLDR As SqlDataReader = sqlCmd.ExecuteReader(CommandBehavior.CloseConnection)
        sqlCmd = Nothing
        Return entrySQLDR
    End Function

    Public Shared Function GetDiaryEntriesByDate(ByVal DiaryId As Integer, ByVal FromDate As Date, ByVal ToDate As Date) As SqlDataReader
        Dim diaryDBConn As New SqlConnection(conString)
        Dim sqlString As String = "GetDiaryEntryByDate"
        Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
        sqlCmd.CommandType = CommandType.StoredProcedure

        sqlCmd.Parameters.AddWithValue("@DiaryId", DiaryId)
        sqlCmd.Parameters.AddWithValue("@FromDate", FromDate)
        sqlCmd.Parameters.AddWithValue("@ToDate", ToDate)

        diaryDBConn.Open()
        Dim entrySQLDR As SqlDataReader = sqlCmd.ExecuteReader(CommandBehavior.CloseConnection)
        sqlCmd = Nothing
        Return entrySQLDR
    End Function

    Public Shared Function GetDiaryEntriesByDateAsCollection(ByVal DiaryId As Integer, ByVal FromDate As Date, ByVal ToDate As Date) As DiaryEntryCollection
        Dim DiaryEntries As New DiaryEntryCollection
        Dim entrySQLDR As SqlDataReader = GetDiaryEntriesByDate(DiaryId, FromDate, ToDate)

        Do While entrySQLDR.Read()
            DiaryEntries.Add(CLng(entrySQLDR("DiaryEntryId")))
        Loop

        entrySQLDR.Close()
        entrySQLDR = Nothing
        Return DiaryEntries
    End Function
#End Region

#Region "Skadniki publiczne"

  Public Sub Save()
    If mDiaryEntryId = -1 Then
      InsertNewDiaryEntry()
    Else
      UpdateDiaryEntry()
    End If
  End Sub

#End Region

End Class